;
;***********************
;  DEMO STEPPING MOTOR *
;     EXPERIMENT 5     *
;***********************
;
         CPU  "Z80.TBL"
         HOF  "INT8"

         ORG  2000H
STPXY:   EQU  0B5H
STPCRTL: EQU  0B7H
DISPY:   EQU  3FE7H
SCANK:   EQU  5
CLEAR:   EQU  3
SYSCAL:  EQU  10H
BEEP:    EQU  0EH
KEYIN:   EQU  3FFBH
SYSFAG:  EQU  3FFDH
DEL:     EQU  0FH
;
START:   LD   A,10011001B
         OUT  (STPCRTL),A

         LD   HL,TAB_DSP
         LD   DE,DISPY
         LD   BC,6
         LDIR

         LD   HL,SYSFAG      ;not check instant key
         SETT 4,(HL)

STT:     LD   A,99H          ;Start phase X,Y
         LD   (PHASEX),A
         LD   (PHASEY),A
         LD   IY,BUFXY
         LD   IX,0
;
MAIN:    LD   HL,0
         LD   (CONTX),HL     ;initial step x,y
         LD   (CONTY),HL
;
MAIN2:   LD   A,SCANK
         RST  SYSCAL
         LD   A,(KEYIN)
         CP   0FFH
         JR   NZ,MAIN21
         XOR  A
         OUT  (STPXY),A
         JR   MAIN2


MAIN21:  CP   0
         JP   Z,PRGXR          ;X RIGHT
         CP   1
         JP   Z,PRGXL          ;X LEFT
         CP   2
         JP   Z,PRGYR          ;Y RIGHT
         CP   3
         JP   Z,PRGYL          ;Y LEFT
         CP   11H
         JP   Z,PRG_RUN        ;RUN
         CP   10H
         JR   NZ,MAIN2

;/* Check mem release */

         LD   A,BEEP
         RST  SYSCAL
MAIN3:   LD   A,SCANK
         RST  SYSCAL
         LD   A,(KEYIN)
         CP   10H
         JR   Z,MAIN3
         JP   PRG_MEM

;
;***********************
;   PROGRAM MOVE X,Y   *
;***********************
;
PRGXR:   CALL PHASXL
         LD   HL,(CONTX)
         INC  HL
         LD   (CONTX),HL
         CALL ENGISE
         JP   MAIN2
;
PRGXL:   CALL PHASXR
         LD   HL,(CONTX)
         DEC  HL
         LD   (CONTX),HL
         CALL ENGISE
         JP   MAIN2
;
PRGYR:   CALL PHASYL
         LD   HL,(CONTY)
         INC  HL
         LD   (CONTY),HL
         CALL ENGISE1
         JP   MAIN2
;
PRGYL:   CALL PHASYR
         LD   HL,(CONTY)
         DEC  HL
         LD   (CONTY),HL
         CALL ENGISE1
         JP   MAIN2
;
;/* MEM X,Y  */

PRG_MEM:
         INC  IX
         LD   HL,(CONTX)
         LD   (IY+0),L       ;stroe x to buff
         INC  IY
         LD   (IY+0),H
         INC  IY
         LD   HL,(CONTY)
         LD   (IY+0),L       ;stroe y to buff
         INC  IY
         LD   (IY+0),H
         INC  IY             ;next pointer
         JP   MAIN
;
;
;***********************
;   PROGRAM RUN  X,Y   *
;***********************
;
PRG_RUN:
         PUSH IX
         POP  HL
         LD   A,L
         OR   H
         JP   Z,MAIN
         LD   IY,BUFXY
;
;/* step X left execute */

RUNX_RL: CALL RD_DAT
         JP   Z,RUNY_RL
         JP   M,RUN_XR
;
RUN_XL:  CALL PHASXL
         CALL ENGISE
         DEC  DE
         LD   A,D
         OR   E
         JR   NZ,RUN_XL
         JR   RUNY_RL
;
;/* step X right execute */

RUN_XR:  CALL NUM_MINUS
RUN_XR1: CALL PHASXR
         CALL ENGISE
         DEC  DE
         LD   A,D
         OR   E
         JR   NZ,RUN_XR1
;
;/* Step Y left execute */

RUNY_RL: CALL RD_DAT
         JR   Z,EN_1PRG
         JP   M,RUN_YR

RUN_YL:  CALL PHASYL
         CALL ENGISE1
         DEC  DE
         LD   A,E
         OR   A
         JR   NZ,RUN_YL
         JR   EN_1PRG
;
;/* Step Y right execute */

RUN_YR:  CALL NUM_MINUS
RUN_YR1: CALL PHASYR
         CALL ENGISE1
         DEC  DE
         LD   A,D
         OR   E
         JR   NZ,RUN_YR1
;
;/* End 1 program */

EN_1PRG:
         LD   A,BEEP
         RST  SYSCAL
         LD   B,50H
         LD   A,DEL
         RST  SYSCAL
         DEC  IX
         PUSH IX
         POP  HL
         LD   A,H
         OR   L
         JP   NZ,RUNX_RL
         JP   STT
;
;***********************
;    READ BUFFER X,Y   *
;***********************

RD_DAT:  LD   E,(IY+0)
         INC  IY
         LD   D,(IY+0)
         INC  IY
         LD   A,D
         OR   E
         RET
;
;***********************
; CHANGE MINUS TO PLUS *
;***********************

NUM_MINUS:
         LD   A,D
         CPLA
         LD   D,A
         LD   A,E
         CPLA
         LD   E,A
         LD   HL,1
         ADD  HL,DE
         EX   DE,HL
         RET

;***********************
;  CONTROL PHASE X ->  *
;***********************
;
PHASXL:  LD   A,(PHASEX)
         RLCA
         LD   (PHASEX),A
         RET
;
;***********************
;  CONTROL PHASE X <-  *
;***********************
;
PHASXR:  LD   A,(PHASEX)
         RRCA
         LD   (PHASEX),A
         RET
;
;***********************
;  CONTROL PHASE Y  ^  *
;***********************
;
PHASYL:  LD   A,(PHASEY)
         RLCA
         LD   (PHASEY),A
         RET
;
;***********************
;  CONTROL PHASE Y  _  *
;***********************
;
PHASYR:  LD   A,(PHASEY)
         RRCA
         LD   (PHASEY),A
         RET
;
;
;***********************
;     ENERGISE PHASE   *
;***********************
;
;*** phase x,y -> ***

ENGISE:  AND 0FH
         OUT  (STPXY),A
         CALL DELAY
         RET
;
;*** phase x,y <- ***

ENGISE1: AND  0F0H
         OUT  (STPXY),A
         CALL DELAY
         RET
;
;
;*** DELAY SUB ***

DELAY:   LD   HL,4000H
DELAY1:  DEC  HL
         LD   A,H
         OR   L
         JR   NZ,DELAY1
         RET
;
TAB_DSP: DFB  00H,73H,50H,5CH,3DH,00H

;*** RAM AREA ***

        ORG  3000H
BUFXY:  DFS  0F00H
CONTX:  DFS   2
CONTY:  DFS   2
PHASEX: DFS   1
PHASEY: DFS   1
PHASEZ: DFS   1
        END

;
